<?php

/**
 *
 */
class NdtModel
{

    /**
     * get a set of NDT results for the given filters
     * parameters vehicleid(int),vrn(string),date(string)
     * returns array
     */
     public static function getNdtResults($vehicleid,$vrn,$date)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $realdate=date('Y-m-d',strtotime("-".$date." weeks"));
        $limit=" ORDER BY id ";
        $search=array();
        $searchcriteria="SELECT * FROM inspection WHERE hasuploads=1 AND ";
        $parameters = array(':vehicleid' => $vehicleid);
        $search[]=" vehicleid=:vehicleid ";
        if($vrn!=""){
           $search[]= " VRN=:vrn ";
           $parameters[':vrn']=$vrn;
        }
        if($date!=""){
           $search[]= " date>:realdate ";
           $parameters[':realdate']=$realdate;
        }
        $searchcriteria.=join(" AND ",$search);
        $searchcriteria.=$limit.";";
        $results=array();
        $metrics=array();
        $ssiresults=array();
        $directory = './NDT';
        $scanned_directory = array_diff(scandir($directory), array('..', '.'));
        $hasresults=false;
        $vehicles=AdminModel::getAllVehicles();
        $vehiclemap=array();
        foreach($vehicles as $vehicle){
           $vehiclemap[$vehicle['id']]=$vehicle['name'];
        }
        $sql=$searchcriteria;
        $query = $database->prepare($sql);
        $query->execute($parameters);
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           //print_r($row);
           $result=array();
           $result['date']=$row['date'];
           $result['operator']=$row['user'];
           $result['vehicle']=$vehiclemap[$row['vehicleid']];
           $result['vrn']=$row['vrn'];
           $result['report']=$row['id'];
           $result['recordid']=$row['recordid'];
           $pods=json_decode(Encryption::decrypt($row['b_pods']),true);
           $version=$row['version'];
           $allmetrics=self::getMetricsQuestions($version,$vehicleid);
           $ssis=array();
           //get scan records
           $sql="SELECT ssiid FROM ndtuploads WHERE recordid=:recordid";
           $parameters2 = array(':recordid' => $row['recordid']);
           $query2 = $database->prepare($sql);
           $query2->execute($parameters2);
           while ($row2 = $query2->fetch(PDO::FETCH_ASSOC)) {
              $ssis[$row2['ssiid']]=array('ssi'=>$row2['ssiid']);
              if(array_key_exists('ndt',$pods[$row2['ssiid']]))$ssis[$row2['ssiid']]['reports']=$pods[$row2['ssiid']]['ndt'];
              $sql3="SELECT filename FROM ndtuploads WHERE ssiid=:ssiid";
              $parameters3 = array(':ssiid' => $row2['ssiid']);
              $query3 = $database->prepare($sql3);
              $query3->execute($parameters3);
              while ($row3 = $query3->fetch(PDO::FETCH_ASSOC)) {
                 $ssis[$row2['ssiid']]['scans'][]=$row3['filename'];
              }
              //$ssis[$row2['ssiid']]['scans'][]=$row2['filename'];
              //$ssis[]=array('ssi'=>$row2['ssiid']);
              //$scans=array();
              //$scans[]=$row2['filename'];

              //$ssis[$row2['ssiid']]['reports']=array('a report');
           }
           //if(in_array($row['recordid'],$scanned_directory)){
              /*$hasresults=true;
              $result=array();
              $result['date']=$row['date'];
              $result['operator']=$row['user'];
              $result['vehicle']=$vehiclemap[$row['vehicleid']];
              $result['vrn']=$row['vrn'];
              $result['report']=$row['id'];
              $result['recordid']=$row['recordid'];
              $version=$row['version'];
              //$allmetrics=$this->getMetricsQuestions($version,$vehicleid);
              //get ssis that have scans
              $ssis=array();
              $ssidata=json_decode($row['pods'],true);
              $allssis=array_keys($ssidata);
              $recorddirectory=array_diff(scandir($directory.'/'.$result['recordid']), array('..', '.'));
              foreach($allssis as $ssi){
                 if(in_array($ssi,$recorddirectory))$ssis[$ssi]=array('ssi'=>$ssi);
              }
              foreach($ssis as $ssi){
                 //get individual scans
                 $scans=array_diff(scandir($directory.'/'.$result['recordid'].'/'.$ssi['ssi']), array('..', '.','reports'));
                 $ssis[$ssi['ssi']]['scans']=$scans;
                 //get reports
                 $reports=array_diff(scandir($directory.'/'.$result['recordid'].'/'.$ssi['ssi'].'/reports'), array('..', '.'));
                 $ssis[$ssi['ssi']]['reports']=$reports;
                 //get metrics
                 $metricresults=array();
                 foreach($ssidata[$ssi['ssi']]['metrics'] as $metric){
                    $description=$allmetrics[$ssi['ssi']][$metric['id']];
                    $metricresults[]=array('id'=>$metric['id'],'description'=>$description,'value'=>$metric['value']);
                 }
                 $metrics[$row['recordid']][$ssi['ssi']]=$metricresults;
              }*/
              //$ssis['abc']=array('ssi'=>'abc');
              //$ssis['abc']['scans']=array('a scan');
              //$ssis['abc']['reports']=array('a report');
              foreach($ssis as $ssi){
                 $metrics[$ssi['ssi']]=$allmetrics[$ssi['ssi']];
              }
              $result['ssis']=$ssis;
              $results[]=$result;
              //print_r($metrics);
        }
        return array('results'=>$results,'metrics'=>$metrics);
     }

    /**
     * get a set of inspection record ids for the given filters
     * parameters vehicleid(int),vrn(string),date(string)
     * returns array
     */
     public static function getInspectionRecordIds($vehicleid,$vrn,$date)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $realdate=date('Y-m-d',strtotime("-".$date." weeks"));
        $limit=" ORDER BY id ";
        $search=array();
        $searchcriteria="SELECT * FROM inspection WHERE";
        $parameters = array(':vehicleid' => $vehicleid);
        $search[]=" vehicleid=:vehicleid ";
        if($vrn!=""){
           $search[]= " VRN=:vrn ";
           $parameters[':vrn']=$vrn;
        }
        if($date!=""){
           $search[]= " date>:realdate ";
           $parameters[':realdate']=$realdate;
        }
        $searchcriteria.=join(" AND ",$search);
        $searchcriteria.=$limit.";";
        $sql=$searchcriteria;
        $query = $database->prepare($sql);
        $query->execute($parameters);
        return $query->fetchAll(PDO::FETCH_ASSOC);
     }

    /**
     * get a set of SSI ids for the given inspection record
     * parameters vehicleid(int),recordid(string)
     * returns JSON string
     */
     public static function getSSIIdByInspectionRecord($vehicleid,$recordid)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $ssiids=array();
        $sql="SELECT b_pods FROM inspection WHERE vehicleid=:vehicleid AND recordid=:recordid";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid,':recordid' => $recordid);
        $query->execute($parameters);
        //$pods=json_decode($query->fetch(PDO::FETCH_ASSOC)['pods'],true);
        $pods=json_decode(Encryption::decrypt($query->fetch(PDO::FETCH_ASSOC)['b_pods']),true);
        foreach($pods as $key=>$value){
           $id=$key;
           $description=self::getSSILongDescription($vehicleid,$id);
           $ssiids[]=array('id'=>$id,'description'=>$description);
        }
        return json_encode($ssiids);
     }

    /**
     * set the has_scans of record to true (1) and creates an NDT upload record
     * parameters username(string),recordid(string),ssiid(string),filename(string)
     * returns int
     */

     public static function setHasScans($username,$recordid,$ssiid,$filename,$size)
     {
        $database = DatabaseFactory::getFactory()->getConnection();
        $sql="INSERT INTO ndtuploads (id,recordid,ssiid,filename,size,owner) VALUES (null,:recordid,:ssiid,:filename,:size,:username)";
        $query = $database->prepare($sql);
        $parameters = array(':recordid' => $recordid,':ssiid' => $ssiid,':filename' => $filename,':size' => $size,':username' => $username);
        $query->execute($parameters);
        $id = $database->lastInsertId();
        $sql="UPDATE inspection SET hasuploads=1 WHERE recordid=:recordid";
        $query = $database->prepare($sql);
        $parameters = array(':recordid' => $recordid);
        $query->execute($parameters);
        return $id;
     }

    /**
     * get the NDT uploads for the given record/ssi
     * parameters recordid(string),ssiid(string)
     * returns JSON string
     */

     public static function getNDTUploads($recordid,$ssiid)
     {
        $database = DatabaseFactory::getFactory()->getConnection();
        $sql="SELECT * FROM ndtuploads WHERE recordid=:recordid AND ssiid=:ssiid";
        $query = $database->prepare($sql);
        $parameters = array(':recordid' => $recordid,':ssiid' => $ssiid);
        $query->execute($parameters);
        return json_encode($query->fetchAll());

     }

    /**
     * get a set of SSI description for the given SSI id (short description)
     * parameters vehicleid(int),ssiid(string)
     * returns array
     */
     private static function getSSILongDescription($vehicleid,$ssiid)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql="SELECT longdescription FROM ssiid WHERE vehicleid=:vehicleid AND shortdescription=:ssiid";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid,':ssiid' => $ssiid);
        $query->execute($parameters);
        return $query->fetch();
     }

    /**
     * get a set of metric questions for the given version and vehicleid
     * parameters version(int) vehicleid(int)
     * returns array
     */

     private static function getMetricsQuestions($version,$vehicleid)
     {
        $database = DatabaseFactory::getFactory()->getConnection();
        $results=array();
        $allmetrics=array();
        $sql="SELECT b_poddata FROM view WHERE version=:version AND vehicleid=:vehicleid and scheduleid=1";
        $query = $database->prepare($sql);
        $parameters = array(':version' => $version,':vehicleid' => $vehicleid);
        $query->execute($parameters);
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           $pods=json_decode(Encryption::decrypt($row['b_poddata']),true);
           foreach($pods as $pod){
               $ssiid=$pod['common']['ssiid'];
               $metrics=$pod['inspection']['metrics'];
               foreach($metrics as $metric){
                  $allmetrics[$ssiid][$metric['id']]=$metric['description'];
               }
           }
        }
        return $allmetrics;
     }

    /**
     * insert metric values and NDT data for the given inspection record and ssi
     * parameters postdata(array),$files(array),directory(string)
     * returns nothing
     */

     public static function insertNdtData($postdata,$directory)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $recordid=$postdata['recordid'];
        $ssiid=$postdata['ssiid'];
        $owner=$postdata['owner'];
        $files=array();
        if(isset($postdata['files']))$files=$postdata['files'];
        unset($postdata['files']);

        //seperate the metrics data from the post array
        $metrics=array_diff($postdata,array($recordid,$ssiid));

        $pods=json_decode(Encryption::decrypt(self::getInspectionRecordPods($recordid)),true);
        foreach($metrics as $key => $value){
           if($value){
              foreach($pods[$ssiid]['metrics'] as &$metric){
                 if($metric['id']==$key)$metric['value']=$value;
              }
           }
        }
        $pods[$ssiid]['complete']=true;
        //$files=$directory.$files['upl']['name'];
        unset($pods[$ssiid]['ndt']);
        if(!array_key_exists('ndt',$pods[$ssiid]))$pods[$ssiid]['ndt']=array();
        foreach($files as $file){
           if(!in_array($file,$pods[$ssiid]['ndt']))array_push($pods[$ssiid]['ndt'],$file);
           //if(!in_array($file,$pods[$ssiid]['ndt']))array_push($pods[$ssiid]['ndt'],array('file' => $file,'owner' => $owner));
        }
        $sql="UPDATE inspection SET b_pods=:pods WHERE recordid=:recordid";
        $query = $database->prepare($sql);
        $parameters = array(':pods' => Encryption::encrypt(json_encode($pods)),':recordid' => $recordid);
        if($query->execute($parameters))return true;
        else return false;
     }

     private static function getInspectionRecordPods($recordid)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $ssiids=array();
        $sql="SELECT b_pods FROM inspection WHERE recordid=:recordid";
        $query = $database->prepare($sql);
        $parameters = array(':recordid' => $recordid);
        $query->execute($parameters);
        $decoded=$query->fetch(PDO::FETCH_ASSOC)['b_pods'];
        return $decoded;
     }

     public static function deleteNDTRecord($id)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql="DELETE FROM ndtuploads WHERE id=:id";
        $query = $database->prepare($sql);
        $parameters = array(':id' => $id);
        if($query->execute($parameters))return true;
        else return false;

     }

}